from itertools import combinations

def is_valid(board, mine_positions):
    board_copy = board[:]
    for pos in mine_positions:
        board_copy[pos] = -2
    if board_copy.count(-2) != len(mine_positions):
        return False

    for i, spot in enumerate(board_copy):
        if spot == -2:
            continue

        left_neighbor = board_copy[i - 1] if i > 0 else None
        right_neighbor = board_copy[i + 1] if i < len(board_copy) - 1 else None

        neighbor_mines = 0
        if left_neighbor == -2:
            neighbor_mines += 1
        if right_neighbor == -2:
            neighbor_mines += 1

        if spot != -1 and spot != neighbor_mines:
            return False

    return True

def generate_variations(board, mine_count):
    hidden_positions = []
    for i, spot in enumerate(board):
        if spot == -1:
            hidden_positions += [i]

    possible_placements = combinations(hidden_positions, mine_count)

    valid_placements = []
    for placement in possible_placements:
        if is_valid(board, placement):
            valid_placements += [placement]

    return valid_placements
    
def board_to_array(board):
    board = board.replace(" ", "")
    minesweeper_board = []

    for spot in board:
        if spot == "-":
            minesweeper_board += [-1]
        else:
            minesweeper_board += [int(spot)]

    return minesweeper_board

def eval_board(mine_count,board):
    board_array = board_to_array(board)
    boards = []

    for placement in generate_variations(board_array, mine_count):
        result_board = [1 if x == -1 else 0 for x in board_array]
        for pos in placement:
            result_board[pos] = 0
        boards += [result_board]

    boards = [sum(x) for x in zip(*boards)]
    max_val = max(boards)
    answer = ["^" if x == max_val else " " for x in boards]

    return f"{mine_count} | {board}\n    {' '.join(answer)}"

def main():
    test_games = [
        [2,"- - - -"],
        [1,"0 1 - -"],
        [4,"- - - 1 - - -"],
        [2,"- - - 1 - - -"],
        [4,"- - 1 - - -"],
        [3,"- - - 1 - 2 -"],
        [4,"- - 2 - - 1 1 - 1 0"],
        [4,"- 1 - - - - 1 - - 1 - -"],
    ]

    for game in test_games:
        print(eval_board(*game))
        print()

if __name__ == "__main__":
    main()