for line in io.lines(...) do
	local mines, msep
	local orig_line = line
	mines, msep, line = line:match('^(%d+)( *|)(.*)$')
	mines = tonumber(mines) or -1
	msep = msep or ""
	line = line or ""
	local off = #(mines .. msep)
	local grid = {}
	for i = 1, #line do
		local c = line:sub(i,i)
		if c == '-' or (tonumber(c) and tonumber(c) <= 2) then
			grid[#grid+1] = {
				off = off + i - 1,
				val = c ~= '-' and tonumber(c),
				mine_hits = 0,
				total_hits = 0,
				local_mines = 0,
				local_hits = 0
			}
		end
	end
	grid.total_hits = 0
	grid.mine_hits = 0
	grid.mines = mines
	local mutagen = {}
	local function writer()
		local off = 0
		return function (x, c)
			c = tostring(c)
			assert(x >= off)
			io.write((' '):rep(x - off), c)
			off = x + #c
		end
	end
	local function postrecur()
		local sels = {}
		for i, v in ipairs(grid) do
			if grid[i].local_mines == 0 and grid[i].local_hits > 0 then
				sels[i] = true
			end
		end
		for i, v in ipairs(grid) do
			if grid[i].local_mines == grid[i].local_hits or (sels[i] and not sels[i]) then
				grid.total_hits = grid.total_hits - grid[i].total_hits
				grid.mine_hits = grid.mine_hits - grid[i].mine_hits
				grid[i].mine_hits = 0
				grid[i].total_hits = 0
			end
		end
	end
	local function recursor(len, mines)
		local function mutaget(i)
			if i > len or i < 1 then return 0 end
			return mutagen[i] and 1 or 0
		end
		local function mutacheck(i)
			if i > len or i < 1 then return true end
			if not (grid[i] or {}).val then return true end
			return mutaget(i - 1) + mutaget(i + 1) == grid[i].val
		end
		if mines < 0 or not mutacheck(len - 1) then
			return
		end
		if len == #grid then
			if mines > 0 or not mutacheck(len) then
				return
			end
			local unknown = 0
			for i = 1, len do
				if not grid[i].val then
					unknown = unknown + 1
				end
			end
			if unknown > grid.mines then
				for i = 1, len do
					grid[i].local_hits = grid[i].local_hits + 1
					grid[i].local_mines = grid[i].local_mines + (mutagen[i] and 1 or 0)
					if mutagen[i] then
						grid.total_hits = grid.total_hits + 1
						grid.mine_hits = grid.mine_hits + 1
						grid[i].mine_hits = grid[i].mine_hits + 1
						grid[i].total_hits = grid[i].total_hits + 1
					elseif not grid[i].val then
						local oldgrid = grid
						grid = {}
						for i, v in ipairs(oldgrid) do
							grid[i] = {
								val = v.val,
								off = v.off,
								mine_hits = 0,
								total_hits = 0,
								local_mines = 0,
								local_hits = 0
							}
						end
						grid.total_hits = 0
						grid.mine_hits = 0
						grid.mines = oldgrid.mines
						local function reveal(i)
							if i > len or i < 1 then return false end
							if mutaget(i) > 0 then return end
							if grid[i].val then return false end
							grid[i].val = mutaget(i - 1) + mutaget(i + 1)
							if grid[i].val == 0 then
								reveal(i - 1)
								reveal(i + 1)
							end
							return true
						end
						reveal(i)
						local oldmutagen = mutagen
						mutagen = {}
						recursor(0, grid.mines)
						postrecur()
						oldgrid[i].mine_hits = oldgrid[i].mine_hits + grid.mine_hits
						oldgrid[i].total_hits = oldgrid[i].total_hits + grid.total_hits
						oldgrid.mine_hits = oldgrid.mine_hits + grid.mine_hits
						oldgrid.total_hits = oldgrid.total_hits + grid.total_hits
						grid = oldgrid
						mutagen = oldmutagen
						unknown = unknown + 1
					end
				end
			else
				grid.total_hits = grid.total_hits + 1
			end
			return
		end
		local i = len + 1
		if not grid[i].val then
			mutagen[i] = true
			recursor(i, mines - 1)
		end
		mutagen[i] = false
		return recursor(i, mines)
	end
	recursor(0, mines)
	postrecur()
	if grid.total_hits == 0 then
		print('invalid board')
	else
		local minimum = math.huge
		for i = 1, #grid do
			if grid[i].mine_hits/grid[i].total_hits < minimum and not grid[i].val then
				minimum = grid[i].mine_hits / grid[i].total_hits
			end
		end
		local function stty(isterm, term)
			if isterm ~= nil then return isterm end
			isterm = os.execute('stty <&'..(term or 0)..' >/dev/null 2>&1')
			if tonumber(isterm) then isterm = tonumber(isterm) == 0 end
			return isterm
		end
		isterm_in = stty(isterm_in, 0)
		isterm_out = stty(isterm_out, 1)
		if isterm_out and not isterm_in then
			io.stderr:write(orig_line .. "\n")
			io.stderr:flush()
		end
		local write = writer()
		for i = 1, #grid do
			if grid[i].mine_hits/grid[i].total_hits == minimum and not grid[i].val then
				write(grid[i].off, '^')
			end
		end
		print(('  %.1f%%'):format(math.floor((1-minimum)*1000+.5)/10))
	end
end
