#!/usr/bin/env node

/**
 *
 *     @@@@@@@  @@@@@@  @@@@@@@  @@@@@@@@  @@@@@@@  @@@  @@@ @@@@@@@@  @@@@@@  @@@@@@    @@@  @@@  @@@  @@@@@@  @@@@@@@  @@@@@@@@ @@@@@@@@
 *    !@@      @@!  @@@ @@!  @@@ @@!      !@@       @@!  @@@ @@!      !@@     !@@        @@!  @@!  @@! @@!  @@@ @@!  @@@ @@!           @@!
 *    !@!      @!@  !@! @!@  !@! @!!!:!   !@! @!@!@ @!@  !@! @!!!:!    !@@!!   !@@!!     @!!  !!@  @!@ @!@!@!@! @!@!!@!  @!!!:!      @!!
 *    :!!      !!:  !!! !!:  !!! !!:      :!!   !!: !!:  !!! !!:          !:!     !:!     !:  !!:  !!  !!:  !!! !!: :!!  !!:       !!:
 *     :: :: :  : :. :  :: :  :  : :: ::   :: :: :   :.:: :  : :: ::  ::.: :  ::.: :       ::.:  :::    :   : :  :   : : : :: ::  :.::.: :
 *
 *
 *    @@@@@@@  @@@@@@@  @@@@@@@@  @@@@@@ @@@@@@@@ @@@  @@@ @@@@@@@  @@@@@@
 *    @@!  @@@ @@!  @@@ @@!      !@@     @@!      @@!@!@@@   @!!   !@@
 *    @!@@!@!  @!@!!@!  @!!!:!    !@@!!  @!!!:!   @!@@!!@!   @!!    !@@!!
 *    !!:      !!: :!!  !!:          !:! !!:      !!:  !!!   !!:       !:!
 *     :        :   : : : :: ::  ::.: :  : :: ::  ::    :     :    ::.: :
 *
 *
 *    @@@      @@@@@@@@  @@@@@@@   @@@@@@  @@@          @@@@@@ @@@  @@@  @@@@@@  @@@  @@@ @@@@@@@@    @@@@@@@   @@@@@@  @@@@@@@
 *    @@!      @@!      !@@       @@!  @@@ @@!         !@@     @@!@!@@@ @@!  @@@ @@!  !@@ @@!         @@!  @@@ @@!  @@@   @!!
 *    @!!      @!!!:!   !@! @!@!@ @!@!@!@! @!!          !@@!!  @!@@!!@! @!@!@!@! @!@@!@!  @!!!:!      @!@!@!@  @!@  !@!   @!!
 *    !!:      !!:      :!!   !!: !!:  !!! !!:             !:! !!:  !!! !!:  !!! !!: :!!  !!:         !!:  !!! !!:  !!!   !!:
 *    : ::.: : : :: ::   :: :: :   :   : : : ::.: :    ::.: :  ::    :   :   : :  :   ::: : :: ::     :: : ::   : :. :     :
 *
 */

const readline = require('readline');
let process = require("node:process");
process.stdin.setEncoding('ascii');

(async () => {
	console.log('ascii');
	let width = 0;
	let height = 0;
	{
		const rl = readline.createInterface({
			input: process.stdin
		})
		for await (const line of rl) {
			if (width == 0) {
				width = parseInt(line, 10);
				continue;
			} else {
				height = parseInt(line, 10);
				break;
			}
		}
	}

	cmd = async (s) => {
		console.log(s);

		let r = new Set();
		{
			const rl = readline.createInterface({
				input: process.stdin
			})
			let i = 0;
			for await (const line of rl) {
				r = r.union(new Set(line.split('$').map(d => d.length + i * width)));
				let head = line.indexOf('0');
				if (head > -1) {
					if (line.indexOf('.') == -1 && ((line + line).indexOf('0$') == -1)) {
						return null;
					}
				}

				if (i == height) {
					break;
				}

				i += 1;
			}
		}
		return r;
	}

	while(1) {
		let last = await cmd('d') ?? new Set();
		for(let i = 0; i < 16; ++i) {
			let n = await cmd('r');
			if (n == null || n.isDisjointFrom(last)) {
				break;
			}
		}
	}
})();
