with Ada.Text_IO; use Ada.Text_IO;
with Ada.Integer_Text_IO; use Ada.Integer_Text_IO;
with Ada.Containers.Ordered_Sets;

procedure Recawoman is
	type Interval is record
		Min : Integer;
		Max : Integer;
	end record;

	function Key (Element : Interval) return Interval
	is
	begin
		return Element;
	end Key;

	function "=" (Left, Right : Interval) return Boolean
	is
	begin
		return
			   (Left.Min <= Right.Min and Left.Max >= Right.Min)
			or (Right.Min <= Left.Min and Right.Max >= Left.Min);
	end "=";

	function "<" (Left, Right : Interval) return Boolean
	is
	begin
		if Left = Right then
			return False;
		end if;

		if (Left.Min = Right.Max + 1)
		or (Right.Min = Left.Max + 1) then
			return False;
		end if;

		return Left.Min < Right.Min;
	end "<";

	function "+" (Left, Right : Interval) return Interval
	is
		R : Interval;
	begin
		R.Min := Integer'Min(Left.Min, Right.Min);
		R.Max := Integer'Max(Left.Max, Right.Max);

		return R;
	end "+";

	package Interval_Sets is new
		Ada.Containers.Ordered_Sets
			(Element_Type => Interval);

	use Interval_Sets;

	type Interval_Access is access all Interval;

	History : Interval_Sets.Set;
	Even    : aliased Interval := (0, 0);
	Odd     : aliased Interval := (0, 0);
	Chosen  : Interval_Access;

	Index : Integer := 0;
	Current_Num : Integer := 0;
	Previous_Num : Integer := 0;

	function Find_Span (History : Interval_Sets.Set;
	                    Value : Interval;
	                    First : out Interval_Sets.Cursor;
	                    Last : out Interval_Sets.Cursor)
		return Boolean
	is
		Temp : Interval_Sets.Cursor;
	begin
		First := History.Floor(Value);
		Last := History.Ceiling(Value);

		if not Has_Element(Last) then
			Last := First;
		end if;

		if not Has_Element(First) then
			First := Last;
		end if;

		if not Has_Element(First) then
			return False;
		end if;

		if Element(First) < Value or Value < Element(Last) then
			return False;
		end if;

		Temp := First;
		loop
			Temp := Previous(Temp);
			exit when (not Has_Element(Temp));
			exit when Element(Temp) < Value;
			First := Temp;
		end loop;

		Temp := Last;
		loop
			Temp := Next(Temp);
			exit when (not Has_Element(Temp));
			exit when Value < Element(Temp);
			Last := Temp;
		end loop;

		return True;
	end Find_Span;

	function Next_Element (History : Interval_Sets.Set;
	                       Even, Odd : Interval;
	                       Index, Previous : Integer)
		return Integer
	is
		First : Interval_Sets.Cursor;
		Last : Interval_Sets.Cursor;
		Low : Integer;
		High : Integer;
	begin
		Low := Previous - Index;
		High := Previous + Index;

		if Previous - Index <= 0 then
			return High;
		end if;

		if Interval'(Low, Low) = Even
		or Interval'(Low, Low) = Odd then
			return High;
		end if;

		if Find_Span(History, Interval'(Low, Low), First, Last) then
			declare
				Pos : Interval_Sets.Cursor := First;
			begin loop
				if Element(Pos) = Interval'(Low, Low) then
					return High;
				end if;

				exit when Pos = Last;
				Pos := Next(Pos);
			end loop; end;
		end if;

		return Low;
	end Next_Element;
begin
	loop
		if Index = 0 then
			Current_Num := 0;
		else
			Current_Num := Next_Element(History, Even, Odd, Index, Previous_Num);
		end if;

		if (Index mod 2) = 0 then
			Chosen := Even'Access;
		else
			Chosen := Odd'Access;
		end if;

		if Current_Num = Chosen.Min - 1 then
			Chosen.Min := Current_Num;
		elsif Current_Num = Chosen.Max + 1 then
			Chosen.Max := Current_Num;
		else
			declare
				Value : Interval := Chosen.all;
				First : Interval_Sets.Cursor;
				Last : Interval_Sets.Cursor;
				Pos : Interval_Sets.Cursor := First;
			begin
				if Find_Span(History, Value, First, Last) then
					Pos := First;
					loop
						Value := Value + Element(Pos);

						exit when Pos = Last;
						Pos := Next(Pos);
					end loop;
				end if;

				loop
					Pos := History.Find(Value);
					exit when not Has_Element(Pos);

					History.Delete(Pos);
				end loop;

				History.Insert(Value);

				Chosen.Min := Current_Num;
				Chosen.Max := Current_Num;
			end;
		end if;


		Put(Current_Num, Width => 0);
		New_Line(1);

		Previous_Num := Current_Num;
		Index := Index + 1;
	end loop;
end Recawoman;
