library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity ram is port(
	clk : in std_logic;
	we : in std_logic;
	a : in std_logic_vector(12 downto 0);
	di : in std_logic_vector(7 downto 0);
	do : out std_logic_vector(7 downto 0)
);
end ram;

architecture classical of ram is
	type memory is array (8191 downto 0) of std_logic_vector(7 downto 0);
	signal RAM : memory;
begin
	process(clk)
	begin
		if (rising_edge(clk) and we = '1') then
			RAM(to_integer(unsigned(a))) <= di;
			do <= di;
		else
			do <= RAM(to_integer(unsigned(a)));
		end if;
	end process;
end classical;


library ieee;
use ieee.std_logic_1164.all;

entity adder1 is
port (
	x, y, z: in std_logic;
	o, c: out std_logic
);
end adder1;

architecture romanesque of adder1 is
begin
	o <= x xor y xor z;
	c <= (x and y) or (y and z) or (x and z);
end romanesque;


library ieee;
use ieee.std_logic_1164.all;

entity adder16 is
port (
	ci : in std_logic;
	co : out std_logic;
	a : in std_logic_vector(15 downto 0);
	b : in std_logic_vector(15 downto 0);
	o : out std_logic_vector(15 downto 0)
);
end adder16;

architecture gothic of adder16 is
	signal c : std_logic_vector(16 downto 0);
begin
	c(0) <= ci;
	
	adders: for i in 0 to 15 generate
		ax: entity work.adder1 port map(a(i), b(i), c(i), o(i), c(i+1));
	end generate;

	co <= c(16);
end gothic;


library ieee;
use ieee.std_logic_1164.all;

entity mux8 is
port (
	i: in std_logic_vector(7 downto 0);
	sel: in std_logic_vector(2 downto 0);
	o: out std_logic
);
end mux8;

architecture renaissance of mux8 is
begin
	with sel select o <=
		i(7) when "111",
		i(6) when "110",
		i(5) when "101",
		i(4) when "100",
		i(3) when "011",
		i(2) when "010",
		i(1) when "001",
		i(0) when "000",
		'0' when others;
end renaissance;


library ieee;
use ieee.std_logic_1164.all;

entity dec8 is
port (
	i: in std_logic_vector(2 downto 0);
	o: out std_logic_vector(7 downto 0)
);
end dec8;

architecture baroque of dec8 is
begin
	with i select o <=
		"00000001" when "000",
		"00000010" when "001",
		"00000100" when "010",
		"00001000" when "011",
		"00010000" when "100",
		"00100000" when "101",
		"01000000" when "110",
		"10000000" when "111",
		"00000000" when others;
end baroque;



library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity recaman is
port (
	clk : in std_logic;
	rst : in std_logic;
	oe : out std_logic;
	do : out std_logic_vector(15 downto 0)
);
end recaman;

architecture modernist of recaman is
	
	-- I/O
	signal ramwe : std_logic;
	signal rama : std_logic_vector(12 downto 0);
	signal ramdi : std_logic_vector(7 downto 0);
	signal ramdo : std_logic_vector(7 downto 0);
	
	signal deco : std_logic_vector(7 downto 0);
	signal muxo : std_logic;
	signal choice : std_logic_vector(15 downto 0);

	signal addci : std_logic;
	signal addco : std_logic;
	signal adda : std_logic_vector(15 downto 0);
	signal addb : std_logic_vector(15 downto 0);
	signal addo : std_logic_vector(15 downto 0);

	-- Registers
	signal ctr : std_logic_vector(15 downto 0);
	signal res : std_logic_vector(15 downto 0);
	signal sub : std_logic_vector(15 downto 0);
	signal isneg : std_logic;

	-- State
	type state_type is (szero, scheck, sread, swrite);
	signal state : state_type;

begin
	RAM: entity work.ram port map(clk, ramwe, rama, ramdi, ramdo);
	ADDER: entity work.adder16 port map(addci, addco, adda, addb, addo);
	
	MUX1: entity work.mux8 port map(ramdo, sub(2 downto 0), muxo);

	DEC1: entity work.dec8 port map(res(2 downto 0), deco);

	process(clk,rst)
	begin
		if rst='1' then
			state <= szero;
		elsif rising_edge(clk) then
			case state is
				when szero => state <= scheck;
				when scheck => state <= sread;
				when sread => state <= swrite;
				when swrite => state <= szero;
			end case;
		end if;
	end process;

	do <= res;
	oe <= '1' when state=sread else '0';

	with state select adda <=
		res when szero,
		res when scheck,
		(others => '0') when sread,
		(others => 'X') when swrite;

	addb <= not ctr when state=szero else ctr;
	addci <= '0' when state=scheck else '1';

	process(state)
	begin
		if rst='1' then
			ctr <= (others => '0');
		elsif state=swrite then
			ctr <= addo; -- ctr+1
		end if;
	end process;
	
	choice <= addo when isneg='1' or muxo='1' else sub;
	
	process(state)
	begin
		if rst='1' then
			res <= (others => '0');
		end if;
		case state is
			when szero =>
				ramdi <= (others => '0');
				rama <= ctr(12 downto 0);
				ramwe <= rst or not (ctr(15) or ctr(14) or ctr(13));

			when scheck =>
				sub <= addo;
				isneg <= not addco;

				ramdi <= (others => 'X');
				rama <= addo(15 downto 3);
				ramwe <= '0';
				
			when sread =>
				res <= choice;

				ramdi <= (others => 'X');
				rama <= choice(15 downto 3);
				ramwe <= '0';

			when swrite =>
				ramdi <= ramdo or deco;
				rama <= res(15 downto 3);
				ramwe <= '1';

		end case;
	end process;


end modernist;


library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity testbench is
end testbench;

architecture postmodern of testbench is
	signal clk : std_logic := '0';
	signal rst : std_logic := '1';
	signal oe : std_logic;
	signal do : std_logic_vector(15 downto 0);
begin
	clk <= not clk after 10 ns;
	rst <= '1', '0' after 100 ns;
	recaman: entity work.recaman port map(clk,rst,oe,do);
end postmodern;

