#include <stddef.h>
#include <stdint.h>
#include <stdio.h>
#include <string.h>

// moremur_fmux + monroemur_fmix
static inline uint64_t mix(uint64_t x) {
	x ^= x >> 27;
	x *= 0xe9846af9b1a615dull;
	x ^= x >> 33;
	x *= 0x3c79ac492ba7b653ul;
	x ^= x >> 27;
	x *= 0xe9846af9b1a615dull;
	x ^= x >> 25;
	x *= 0x1c69b3f74ac4ae35ul;
	x ^= x >> 27;
	return x;
}

static inline uint64_t rotl(uint64_t x, int n) { return (x << n) | (x >> (-n & 63)); }

// some weird amalgamation of murmur, ottrhash, and chibihash.
// nyaa =^w^=
uint64_t deerhash(const void* data, size_t len) {
	const uint64_t K = 0x2f9d328152f9a0b6;
	const uint64_t S = 0xecb3622aac931b14;
	uint64_t s = rotl(S - K, 15) + rotl(S - K, 47);
	uint64_t h[4] = { S, S + K, s, s + (K * K ^ K) };

	const uint8_t* start = (const uint8_t*) data;
	const uint8_t* end = start + len;

	while (end - start >= 32) {
		const uint64_t* abcd = (const uint64_t*) start;
		start += 32;

		h[0] = (abcd[0] + h[0]) * K;
		h[1] += rotl(abcd[0], 27);
		
		h[1] = (abcd[1] + h[1]) * K;
		h[2] += rotl(abcd[1], 27);
		
		h[2] = (abcd[2] + h[2]) * K;
		h[3] += rotl(abcd[2], 27);

		h[3] = (abcd[3] + h[3]) * K;
		h[0] += rotl(abcd[3], 27);
	}

	while (end - start > 0) {
		h[0] = rotl(h[1] * K, 31) ^ (h[1] >> 31);
		h[1] = rotl((*start++) * K, 31) ^ (h[1] >> 31);
	}

	h[2] = mix(rotl(h[2] * K, 31) ^ (h[3] >> 31));
	h[1] = mix(rotl(h[1] * K, 31) ^ (h[2] >> 31));
	return mix(rotl(h[0] * K, 31) ^ (h[1] >> 31));
}

int main(int argc, const char** argv) {
	for(int i = 0; i < argc; ++i) {
		size_t len = strlen(argv[i]);
		printf("%s = %08llx\n", argv[i], deerhash(argv[i], len));
	}

	return 0;
}