#include <string.h>
#include <stddef.h>
#include <sys/types.h>

ssize_t getrandom(void *buf, size_t buflen, unsigned int flags);

#if defined(__linux)
#include <sys/syscall.h>
#include <stdarg.h>
#include <dlfcn.h>

long syscall(long number, ...) {
    static long (*orig_syscall)(long, ...) = NULL;

    if (number == __NR_getrandom) {

        va_list ap;
        va_start(ap, number);

        void *buf = va_arg(ap, void *);
        size_t buflen = va_arg(ap, size_t);
        unsigned int flags = va_arg(ap, unsigned int);

        va_end(ap);
        return getrandom(buf, buflen, flags);
    }

    if (!orig_syscall)
        orig_syscall = (long (*)(long, ...)) dlsym(RTLD_NEXT, "syscall");

    __builtin_return(__builtin_apply((void (*)()) orig_syscall, __builtin_apply_args(), 100));
}

#endif

ssize_t getrandom(void *buf, size_t buflen, unsigned int flags) {
    memset(buf, 42, buflen); // fair dice roll

    return buflen;
}

ssize_t __vdso_getrandom(void *buf, size_t buflen, unsigned int flags) {
    return getrandom(buf, buflen, flags);
}

int RAND_bytes(unsigned char *buf, int num) {
    getrandom(buf, num, 0);

    return 1;
}
