! Copyright (C) 2025 Aleksander "olus2000" Sabak.
! See https://factorcode.org/license.txt for BSD license.
USING: accessors assocs byte-arrays io io.encodings.binary
io.streams.byte-array kernel math sequences ;
IN: lzw


! Encoding

<PRIVATE

CONSTANT: dict-limit 0x10000

TUPLE: encoder-tree index next ;

: <encoder-tree> ( index -- tree ) H{ } clone encoder-tree boa ;

: <encoder-root> ( -- root )
  f 256 <iota> dup [ <encoder-tree> ] map H{ } zip-as
  encoder-tree boa ;

: next? ( tree byte -- tree? ) swap next>> at ; inline

: write2 ( u16 -- ) 256 /mod write1 write1 ;

: encode-step ( root size node byte -- root size node' )
  2dup next? [ 2nip ]
  [ [ [ 1 + ] [ <encoder-tree> ] bi ] 2dip
    [ swap [ index>> write2 ] [ next>> set-at ] bi ] keep
    overd next? ] if* ;

PRIVATE>

: write-lzw ( -- )
  <encoder-root> 256 over [ read1 ]
  [ encode-step over dict-limit >
    [ [ 2drop <encoder-root> 256 over ] dip index>> next? ]
    when ] while* index>> [ write2 ] when* 2drop ;

: >lzw ( bytes -- encoded )
  binary [ binary [ write-lzw ] with-byte-writer ]
  with-byte-reader ;


! Decoding

<PRIVATE

: <decoder-dict> ( -- dict ) 256 <iota> [ 1byte-array ] map ;

: read2 ( -- u16? )
  read1 read1 2dup and [ 256 * + ] [ nip ] if ;

: init-decoder ( -- dict prev? )
  <decoder-dict> read2 dup [ over nth dup write ] when ;

: decode-step ( dict prev new -- dict' prev' )
  pick length over > [ pick nth ] [ drop dup dup first suffix ]
  if [ first suffix suffix ] keep dup write ;

PRIVATE>

: read-lzw ( -- )
  init-decoder [ read2 ]
  [ decode-step over length dict-limit >=
    [ 2drop init-decoder ] when ] while* 2drop ;

: lzw> ( encoded -- bytes )
  binary [ binary [ read-lzw ] with-byte-writer ]
  with-byte-reader ;
