#!/usr/bin/sed -nrf

:_Problem
	# SAT solver
	# https://codeguessing.gay/92/
:_Restrictions
	# expr: ( expr ) | ( NOT expr ) | ( expr AND expr ) | ( expr OR expr ) | TRUE | FALSE | P | Q | R | S | T


:main
	1v;h;x
	s:.{111}:&\\\n:g #cg only
	p;z;x
	b identify_variables
	:continue_1_m
	b generate_all_variable_combinations
	:continue_2_m
	b evaluate_all
	:continue_3_m
b display_result

:identify_variables
	x;G
	s/\n.*\bP\b/P:&/
	s/\n.*\bQ\b/Q:&/
	s/\n.*\bR\b/R:&/
	s/\n.*\bS\b/S:&/
	s/\n.*\bT\b/T:&/
	/^\n.*$/{
		s::zero variables#;:
		b continue_1_m
	}
	s/:\n.*$/\n;P1Q1R1S1T1P:Q2P:R2P:S2P:T2Q:R2Q:S2Q:T2R:S2R:T2S:T2P:Q:R3P:Q:S3P:Q:T3P:R:S3P:R:T3P:S:T3/
	s/$/Q:R:S3Q:R:T3Q:S:T3R:S:T3P:Q:R:S4P:Q:R:T4P:Q:S:T4P:R:S:T4Q:R:S:T4P:Q:R:S:T5/
	s/1/=f#=t#;/g
	s/2/=f:f#=f:t#=t:f#=t:t#;/g
	s/3/=f:f:f#=f:f:t#=f:t:f#=f:t:t#=t:f:f#=t:f:t#=t:t:f#=t:t:t#;/g
	s/4/=f:f:f:f#=f:f:f:t#=f:f:t:f#=f:f:t:t#=f:t:f:f#=f:t:f:t#=f:t:t:f#=f:t:t:t#=t:f:f:f#=t:f:f:t#=t:f4/g
	s/4/:t:f#=t:f:t:t#=t:t:f:f#=t:t:f:t#=t:t:t:f#=t:t:t:t#;/g
	s/5/=f:f:f:f:f#=f:f:f:f:t#=f:f:f:t:f#=f:f:f:t:t#=f:f:t:f:f#=f:f:t:f:t#=f:f:t:t:f#=f:f:t:t:t#=f:t:f5/g
	s/5/:f:f#=f:t:f:f:t#=f:t:f:t:f#=f:t:f:t:t#=f:t:t:f:f#=f:t:t:f:t#=f:t:t:t:f#=f:t:t:t:t#=t:f:f:f:f#=5/g
	s/5/t:f:f:f:t#=t:f:f:t:f#=t:f:f:t:t#=t:f:t:f:f#=t:f:t:f:t#=t:f:t:t:f#=t:f:t:t:t#=t:t:f:f:f#=t:t:f:5/g
	s/5/f:t#=t:t:f:t:f#=t:t:f:t:t#=t:t:t:f:f#=t:t:t:f:t#=t:t:t:t:f#=t:t:t:t:t#;/g
	s/^([^\n]+)\n.*;\1(=[^;]+;).*$/\1\2/
b continue_1_m

:generate_all_variable_combinations
	x;G
	/^([^\n]+)\n(zero variables#);/{
		s::\2-\1;:
		b continue_2_m
	}
	s:#(.*)$:#-\1#:
	:copy_loop_gavc
		s:^(.*)\n.*#-:&\1:
		h;x
		s/^.*\n([^=]+).*=([^#]+)(#-[^=;]+).*$/>\1:=@\2:\3/
		:assignment_loop_gavc
			:loop_gavc
				s:>([PQRST])(.*@)([ft])(.*#-.*)\b\1\b:>\1\2\3\4\3:
			t loop_gavc
			s/>([PQRST]:)(.*)@([ft]:)/\1>\2\3@/
		/>=.*@#/! b assignment_loop_gavc
		s:.*-::
		x;G
		s:#-[^=;]+(.*)\n(.*)$:#-\2\1:
		s:-([^#]+)#:\1#-:
	/#-$/!b copy_loop_gavc
	s:^.*\n([^#]+#)(.*)#-$:\1-\2:
	s:f:FALSE:g
	s:t:TRUE:g
b continue_2_m

:evaluate_all
	/#-((FALSE)|(TRUE));$/b continue_3_m
	s:#-([^=;]+)([=;]):#-<EVAL>\1#return_eval_result_ea<LAVE>\2:
	b eval
	:return_eval_result_ea
		s:<EVAL>((FALSE)|(TRUE))##return_eval_result_ea<LAVE>:\1:
	s:#-((FALSE)|(TRUE))([^#]+)#:#\1\4#-:
b evaluate_all

:display_result
	s:-::
	/zero variables/{
		s:^(zero variables)#FALSE;$:>[contradiction] \1;:
		s:^(zero variables)(#TRUE;)$:>[tautology] \1\2:
		b print_cleanup_dr
	}
	s:^[^=]+(=[^#]+#TRUE)+;$:&none:
	s:=[^#]+#FALSE::g
	/^(.*;)none$/{
		s::>[tautology] \1:
		b print_cleanup_dr
	}
	/=/{
		s:^:>[satisfied] :
		b print_cleanup_dr
	}
	s:^(.*);$:>[contradiction] \1=;:
	:print_cleanup_dr
		s:#TRUE::g
		s:=: = :g
		s: ?;$::
		s:.{111}:&\\\n:g #cg only
	p;x;z;$!p;x
b EOS

:user_redirects
	/##return_eval_result_ea<LAVE>/ b return_eval_result_ea
b EOS

###################################   BOOLEAN LIB   ###################################

#1: <NOT>FALSE#label<TON> -> <NOT>TRUE##label<TON>
#1: <NOT>TRUE#label<TON> -> <NOT>FALSE##label<TON>
:not
	t not
	s:(<NOT>)TRUE#:\1FALSE##:; t redirect
	s:(<NOT>)FALSE#:\1TRUE##:
b redirect

#2: <AND>FALSE FALSE#label<DNA> -> <AND>FALSE##label<DNA>
#2: <AND>FALSE TRUE#label<DNA> -> <AND>FALSE##label<DNA>
#2: <AND>TRUE FALSE#label<DNA> -> <AND>FALSE##label<DNA>
#2: <AND>TRUE TRUE#label<DNA> -> <AND>TRUE##label<DNA>
:and
	t and
	s:(<AND>TRUE) TRUE#:\1##:; t redirect
	s:(<AND>)[^#]+#:\1FALSE##:
b redirect

#2: <OR>FALSE FALSE#label<RO> -> <OR>FALSE##label<RO>
#2: <OR>FALSE TRUE#label<RO> -> <OR>TRUE##label<RO>
#2: <OR>TRUE FALSE#label<RO> -> <OR>TRUE##label<RO>
#2: <OR>TRUE TRUE#label<RO> -> <OR>TRUE##label<RO>
:or
	t or
	s:(<OR>FALSE) FALSE#:\1##:; t redirect
	s:(<OR>)[^#]+#:\1TRUE##:
b redirect

#1: <EVAL>false_boolean_expression#label<LAVE> -> <EVAL>FALSE##label<LAVE>
#1: <EVAL>true_boolean_expression#label<LAVE> -> <EVAL>TRUE##label<LAVE>
:eval
	/<EVAL>((FALSE)|(TRUE))#/{
		s::&#:
		b redirect
	}
	s:(<EVAL>[^#]*)\( ((FALSE)|(TRUE)) \):\1\2:
	/(<EVAL>[^#]*)\( NOT ((FALSE)|(TRUE)) \)/{
		s::\1<NOT>\2#return_NOT_result_e<TON>:
		b not
		:return_NOT_result_e
			s:<NOT>((FALSE)|(TRUE))##return_NOT_result_e<TON>:\1:
	}
	/(<EVAL>[^#]*)\( ((FALSE)|(TRUE)) AND ((FALSE)|(TRUE)) \)/{
		s::\1<AND>\2 \5#return_AND_result_e<DNA>:
		b and
		:return_AND_result_e
			s:<AND>((FALSE)|(TRUE))##return_AND_result_e<DNA>:\1:
	}
	/(<EVAL>[^#]*)\( ((FALSE)|(TRUE)) OR ((FALSE)|(TRUE)) \)/{
		s::\1<OR>\2 \5#return_OR_result_e<RO>:
		b or
		:return_OR_result_e
			s:<OR>((FALSE)|(TRUE))##return_OR_result_e<RO>:\1:
	}
b eval

##################################   FUNCTION GLUE   ##################################

:redirect
	/##return_NOT_result_e<TON>/ b return_NOT_result_e
	/##return_AND_result_e<DNA>/ b return_AND_result_e
	/##return_OR_result_e<RO>/ b return_OR_result_e
b user_redirects

:EOS
