! Copyright (C) 2026 Aleksander "olus2000" Sabak.
! See https://factorcode.org/license.txt for BSD license.
USING: bit-arrays effects help.markup help.syntax kernel quotations ;
IN: code-guessing.092

HELP: incorrect-number-of-outputs
{ $values
    { "quot" quotation } { "got" effect } { "expected" effect }
}
{ $description "Throws an " { $link incorrect-number-of-outputs } " error." }
{ $error-description "Thrown when the quotation passed to " { $link satisfy } " macro produces no outputs or more than one output." } ;

HELP: not-satisfiable
{ $values
    { "quot" quotation }
}
{ $description "Throws a " { $link not-satisfiable } " error." }
{ $error-description "Thrown when the predicate passed to " { $link satisfy } " is not satisfiable." } ;

HELP: satisfy
{ $values
    { "pred" { $quotation ( ... -- ? ) } }
    { "quot" { $quotation ( -- bit-array ) } }
}
{ $description "Compiles a " { $link bit-array } " with booleans that result in a truthy output when passed to it." }
{ $errors "Throws a " { $link incorrect-number-of-outputs } " error if " { $snippet "pred" } " produces no outputs or more than one ouput." $nl "Throws a " { $link not-satisfiable } " error if " { $snippet "pred" } " is not satisfiable." } ;

ARTICLE: "code-guessing.092" "code-guessing.092"
{ $vocab-link "code-guessing.092" } " is an implementation of a SAT solver macro for round 92 of the " { $url "https://codeguessing.gay/92/" "code guessing" } " contest." ;

ABOUT: "code-guessing.092"
