import requests as r # dependency
import html.parser as p


# how to run:
# 1) input data on https://codeguessing.gay as appropriate
# 2) run python tiebreaker.py <n> where n is the round number you want calculated


def get_cg(n):
    return r.get(f'https://codeguessing.gay/{n}/').text


class CGParser(p.HTMLParser):

    TARGET_PATH = ['html','body', 'ol', 'li', 'details', 'summary', 'strong']

    def reset(self, *args, **kwargs):
        super().reset(*args, **kwargs)
        self.path = []
        self.output = None


    def handle_starttag(self, tag, _):
        if not self.output:
            self.path.append(tag)


    def handle_endtag(self, tag):
        if not self.output:
            self.path = self.path[:-self.path[::-1].index(tag) - 1]


    def handle_data(self, data):
        if not self.output and self.path == self.TARGET_PATH:
            self.output = data


def get_winner(n):
    c = CGParser()
    c.feed(get_cg(n))
    return c.output


if __name__ == '__main__':
    import sys
    print(get_winner(int(sys.argv[1])), end='')
