
-- all numbers are 32bit, except for appended length

local spack <const>, sunpack <const> = string.pack, string.unpack
local format <const>, rep <const> = string.format, string.rep
local K <const> = {
	0x428a2f98, 0x71374491, 0xb5c0fbcf, 0xe9b5dba5,
	0x3956c25b, 0x59f111f1, 0x923f82a4, 0xab1c5ed5,
	0xd807aa98, 0x12835b01, 0x243185be, 0x550c7dc3,
	0x72be5d74, 0x80deb1fe, 0x9bdc06a7, 0xc19bf174,
	0xe49b69c1, 0xefbe4786, 0x0fc19dc6, 0x240ca1cc,
	0x2de92c6f, 0x4a7484aa, 0x5cb0a9dc, 0x76f988da,
	0x983e5152, 0xa831c66d, 0xb00327c8, 0xbf597fc7,
	0xc6e00bf3, 0xd5a79147, 0x06ca6351, 0x14292967,
	0x27b70a85, 0x2e1b2138, 0x4d2c6dfc, 0x53380d13,
	0x650a7354, 0x766a0abb, 0x81c2c92e, 0x92722c85,
	0xa2bfe8a1, 0xa81a664b, 0xc24b8b70, 0xc76c51a3,
	0xd192e819, 0xd6990624, 0xf40e3585, 0x106aa070,
	0x19a4c116, 0x1e376c08, 0x2748774c, 0x34b0bcb5,
	0x391c0cb3, 0x4ed8aa4a, 0x5b9cca4f, 0x682e6ff3,
	0x748f82ee, 0x78a5636f, 0x84c87814, 0x8cc70208,
	0x90befffa, 0xa4506ceb, 0xbef9a3f7, 0xc67178f2,
}
local sha256values <const> = function(s)
	local K = K
	
	s = s .. "\x80" .. rep("\x00", (55-#s)%64) .. spack(">I8", #s*8)
	
	local h0, h1, h2, h3, h4, h5, h6, h7 =
		0x6a09e667, 0xbb67ae85, 0x3c6ef372, 0xa54ff53a,
		0x510e527f, 0x9b05688c, 0x1f83d9ab, 0x5be0cd19
	
	for j = 1, #s, 64 do
		local w = {sunpack("> I4I4I4I4 I4I4I4I4 I4I4I4I4 I4I4I4I4", s, j)}
		
		for i = 17, 64 do
			-- function rightrot(x,y) return (x >> y) | ((x << (32-y)) & 0xffffffff) end
			local wim15, wim2 = w[i-15], w[i-2]
			local s0 = (wim15 >> 3)
			         ~ ((wim15 >>  7) | (wim15 << 25))
			         ~ ((wim15 >> 18) | (wim15 << 14))
			local s1 = (wim2 >> 10)
			         ~ ((wim2 >> 17) | (wim2 << 15))
			         ~ ((wim2 >> 19) | (wim2 << 13))
			w[i] = (w[i-16] + s0 + w[i-7] + s1) & 0xffffffff
		end
		
		local a, b, c, d, e, f, g, h = h0, h1, h2, h3, h4, h5, h6, h7
		
		for i=1,64 do
			-- function rightrot(x,y) return (x >> y) | ((x << (32-y)) & 0xffffffff) end
			local S1 = ((e >>  6) | (e << 26))
			         ~ ((e >> 11) | (e << 21))
			         ~ ((e >> 25) | (e <<  7))
		--	local ch = (e & f) ~ ((~e) & g) -- bitwise choice
			local ch = g ~ (e & (f ~ g))
			local temp1 = h + S1 + ch + K[i] + w[i]
			
			local S0 = ((a >>  2) | (a << 30))
			         ~ ((a >> 13) | (a << 19))
			         ~ ((a >> 22) | (a << 10))
		--	local maj = (a & b) ~ (a & c) ~ (b & c) -- bitwise majority
			local maj = (a & b) ~ (c & (a ~ b))
			local temp2 = S0 + maj

			a, b, c, d, e, f, g, h =
				(temp1 + temp2) & 0xffffffff, a, b, c,
				(temp1 + d    ) & 0xffffffff, e, f, g
		end
		
		h0, h1, h2, h3, h4, h5, h6, h7 =
			(h0+a)&0xffffffff, (h1+b)&0xffffffff, (h2+c)&0xffffffff, (h3+d)&0xffffffff,
			(h4+e)&0xffffffff, (h5+f)&0xffffffff, (h6+g)&0xffffffff, (h7+h)&0xffffffff
	end
	
	return h0, h1, h2, h3, h4, h5, h6, h7
end

local function sha256byte(s) return spack(">I4I4I4I4 I4I4I4I4", sha256values(s)) end

local function sha256hex(s)
	return format("%08x%08x%08x%08x%08x%08x%08x%08x", sha256values(s))
end

---[[
local tests = {
	{ "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855",
		"" },
	{ "ca978112ca1bbdcafac231b39a23dc4da786eff8147c4e72b9807785afee48bb",
		"a" },
	{ "f07f9e2b2bb62bdbbda731319f19cec91f369ce1f6cb1d6ba8e8b962d1c73d3a",
		"jk8ssl" },
	{ "edeaaff3f1774ad2888673770c6d64097e391bc362d7d6fb34982ddf0efd18cb",
		"abc\n" },
	{ "ba7816bf8f01cfea414140de5dae2223b00361a396177a9cb410ff61f20015ad",
		"abc" },
	{ "f7846f55cf23e14eebeab5b4e1550cad5b509e3348fbc4efa3a1413d393cb650",
		"message digest" },
	{ "3520b54ccec750d15256ada5b3d51cfddcec7fad1482f6bde2ea1c31a2c5b3a5",
		"message digest\n" },
	{ "71c480df93d6ae2f1efad1447c66c9525e316218cf51fc8d9ed832f2daf18b73",
		"abcdefghijklmnopqrstuvwxyz" },
	{ "db4bfcbd4da0cd85a60c3c37d3fbd8805c77f15fc6b1fdfe614ee0a7c8fdb4c0",
		"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789" },
	{ "f371bc4a311f2b009eef952dd83ca80e2b60026c8e935592d0f9c308453c813e",
		"12345678901234567890123456789012345678901234567890123456789012345678901234567890" },
	{ "2edc986847e209b4016e141a6dc8716d3207350f416969382d431539bf292e4a",
		rep("a",1024) },
}

for i, test in ipairs(tests) do
	local r = sha256hex(test[2])
	if test[1] == r then print(i, "PASS")
	else print(i, "FAIL", test[1], r)
	end
end
--]]

return sha256hex, sha256byte, sha256values
