#include <stdio.h>
#include <string.h>

#include "code.c"

void
real_print(const char* msg)
{
  fprintf(stderr, "%s\n", msg);
}

int
submit_io_guess(int num, void* data)
{
  if (*((int*)data) != 42) {
    abort();
  }

  fprintf(stderr, "\nMy guess is: ");
  fflush(stderr);
  fprintf(stdout, "%d\n", num);
  fflush(stdout);

  while (1) {
    char buf[64];
    fprintf(stderr, "? ");
    fflush(stderr);

    if (!fgets(buf, sizeof(buf), stdin)) {
      exit(1);
    }

    if (buf[strlen(buf) - 1] == '\n') {
      buf[strlen(buf) - 1] = '\0';
    }

    if (strcmp(buf, "HIGH") == 0) {
      return 1;
    } else if (strcmp(buf, "LOW") == 0) {
      return -1;
    } else if (strcmp(buf, "WIN") == 0) {
      return 0;
    }

    fprintf(stderr, "My guess is %d. Type \"LOW\" if too LOW, \"HIGH\" if too high, \"WIN\" if correct. No quotes or spaces.\n", num);
  }
}

int
main()
{
  if (!isatty(STDOUT_FILENO)) {
    if (!freopen("/dev/null", "w", stderr)) {
      return 1;
    }
  }

  fprintf(stderr, "Think of a number between 1 and 100.\n");
  fprintf(stderr, "I will guess the number.\n");
  fprintf(stderr, "If my guess is too low, type \"LOW\".\n");
  fprintf(stderr, "If my guess is too high, type \"HIGH\".\n");
  fprintf(stderr, "If my guess is correct, type \"WIN\", and the game will end.\n");

  struct guesser_data guesser_data;
  int cookie = 42;
  init_guesser_data(&guesser_data, submit_io_guess, (void*)&cookie);
  guesser_data.print = real_print;

  guesser_basic(&guesser_data);
}
